<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) : 'Twitch Stream Tracker - Vertali Group'; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=JetBrains+Mono:wght@400;500;600;700&display=swap" rel="stylesheet">
    <?php if (isset($includeCharts) && $includeCharts): ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <?php endif; ?>
    <style>
        :root {
            --primary: #6366F1;
            --primary-dark: #4F46E5;
            --primary-light: #818CF8;
            --secondary: #06B6D4;
            --secondary-dark: #0891B2;
            --accent: #8B5CF6;
            --success: #10B981;
            --warning: #F59E0B;
            --danger: #EF4444;
            --vod-color: #8B5CF6;
            --live-color: #10B981;
            --bg-primary: #0A0E1A;
            --bg-secondary: #141B2D;
            --bg-tertiary: #1E2839;
            --bg-elevated: #1A2332;
            --border-primary: rgba(99, 102, 241, 0.15);
            --border-secondary: rgba(148, 163, 184, 0.08);
            --text-primary: #F8FAFC;
            --text-secondary: #E2E8F0;
            --text-tertiary: #94A3B8;
            --text-muted: #64748B;
            --shadow-xs: 0 1px 2px 0 rgba(0, 0, 0, 0.1);
            --shadow-sm: 0 2px 4px 0 rgba(0, 0, 0, 0.15);
            --shadow-md: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
            --shadow-lg: 0 8px 16px 0 rgba(0, 0, 0, 0.25);
            --shadow-xl: 0 16px 32px 0 rgba(0, 0, 0, 0.3);
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 20px;
            --spacing-xs: 0.5rem;
            --spacing-sm: 0.75rem;
            --spacing-md: 1rem;
            --spacing-lg: 1.5rem;
            --spacing-xl: 2rem;
            --spacing-2xl: 3rem;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        ::-webkit-scrollbar {
            width: 12px;
            height: 12px;
        }

        ::-webkit-scrollbar-track {
            background: var(--bg-primary);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--bg-tertiary);
            border-radius: 6px;
            border: 2px solid var(--bg-primary);
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--primary);
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--bg-primary);
            background-image: 
                radial-gradient(at 0% 0%, rgba(99, 102, 241, 0.1) 0%, transparent 50%),
                radial-gradient(at 100% 100%, rgba(6, 182, 212, 0.1) 0%, transparent 50%);
            color: var(--text-primary);
            line-height: 1.6;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            min-height: 100vh;
        }

        .container {
            max-width: 1728px;
            margin: 0 auto;
            padding: var(--spacing-xl);
            display: flex;
            flex-direction: column;
            gap: var(--spacing-xl);
            min-height: 100vh;
        }

        .dashboard-wrapper {
            display: grid;
            grid-template-columns: 280px 1fr;
            gap: var(--spacing-xl);
        }

        .profile-sidebar {
            display: flex;
            flex-direction: column;
            gap: var(--spacing-lg);
        }

        .header {
            grid-column: 1 / -1;
            background: transparent;
            border: none;
            border-radius: 0;
            padding: 0;
            display: grid;
            grid-template-columns: 1fr;
            gap: var(--spacing-lg);
            position: relative;
            z-index: 100;
            margin-bottom: var(--spacing-xl);
        }

        .header-top {
            display: grid;
            grid-template-columns: auto 1fr auto;
            gap: var(--spacing-xl);
            align-items: center;
            background: linear-gradient(135deg, 
                rgba(20, 30, 48, 0.95) 0%, 
                rgba(15, 23, 42, 0.95) 50%,
                rgba(20, 30, 48, 0.95) 100%);
            border: 1px solid rgba(99, 102, 241, 0.2);
            border-radius: 24px;
            padding: var(--spacing-xl) var(--spacing-2xl);
            box-shadow: 
                0 8px 32px rgba(0, 0, 0, 0.4),
                0 0 0 1px rgba(255, 255, 255, 0.05) inset,
                0 0 60px rgba(99, 102, 241, 0.1);
            backdrop-filter: blur(40px) saturate(200%);
            position: relative;
            overflow: hidden;
        }

        .header-top::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(99, 102, 241, 0.1), 
                transparent);
            animation: sweep 8s ease-in-out infinite;
        }

        @keyframes sweep {
            0%, 100% { left: -100%; }
            50% { left: 100%; }
        }

        .header-top::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, 
                transparent,
                var(--primary),
                var(--secondary),
                var(--accent),
                var(--secondary),
                var(--primary),
                transparent);
            background-size: 200% 100%;
            animation: shimmer-border 3s linear infinite;
        }

        @keyframes shimmer-border {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary), var(--accent), var(--primary));
            background-size: 300% 100%;
            animation: shimmer 4s linear infinite;
        }

        @keyframes shimmer {
            0% { background-position: 300% 0; }
            100% { background-position: -300% 0; }
        }

        .header::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 50% 0%, rgba(99, 102, 241, 0.1), transparent 70%);
            pointer-events: none;
        }

        .header:hover {
            box-shadow: var(--shadow-xl);
            border-color: var(--border-primary);
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: var(--spacing-lg);
            position: relative;
            z-index: 1;
        }

        .logo {
            display: flex;
            align-items: center;
            gap: var(--spacing-md);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .logo-icon-wrapper {
            position: relative;
            width: 64px;
            height: 64px;
        }

        .logo-icon {
            width: 64px;
            height: 64px;
            background: linear-gradient(135deg, 
                var(--primary) 0%, 
                var(--secondary) 50%, 
                var(--accent) 100%);
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.75rem;
            box-shadow: 
                0 10px 40px rgba(99, 102, 241, 0.5),
                0 0 0 2px rgba(255, 255, 255, 0.1) inset,
                0 0 80px rgba(99, 102, 241, 0.3);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .logo-icon::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, 
                transparent 30%, 
                rgba(255, 255, 255, 0.3) 50%, 
                transparent 70%);
            transform: rotate(45deg);
            transition: all 0.8s ease;
        }

        .logo-icon::after {
            content: '';
            position: absolute;
            inset: -2px;
            border-radius: 18px;
            padding: 2px;
            background: linear-gradient(135deg, 
                var(--primary), 
                var(--secondary), 
                var(--accent));
            -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .logo:hover .logo-icon {
            transform: rotate(12deg) scale(1.1);
            box-shadow: 
                0 16px 48px rgba(99, 102, 241, 0.7),
                0 0 0 2px rgba(255, 255, 255, 0.2) inset,
                0 0 120px rgba(99, 102, 241, 0.5);
        }

        .logo:hover .logo-icon::before {
            left: 100%;
            top: 100%;
        }

        .logo:hover .logo-icon::after {
            opacity: 1;
        }

        .logo-text-wrapper {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }

        .logo-text {
            font-size: 1.875rem;
            font-weight: 900;
            letter-spacing: -1px;
            background: linear-gradient(135deg, 
                var(--text-primary) 0%, 
                var(--primary-light) 50%, 
                var(--secondary) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1.2;
            transition: all 0.3s ease;
        }

        .logo:hover .logo-text {
            background: linear-gradient(135deg, 
                var(--primary-light) 0%, 
                var(--secondary) 50%, 
                var(--accent) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            filter: drop-shadow(0 0 8px rgba(99, 102, 241, 0.5));
        }

        .logo-tagline {
            font-size: 0.6875rem;
            color: var(--text-tertiary);
            font-weight: 500;
            letter-spacing: 0.5px;
            text-transform: uppercase;
        }

        .beta-badge {
            display: inline-flex;
            align-items: center;
            padding: 6px 16px;
            background: linear-gradient(135deg, 
                rgba(139, 92, 246, 0.3), 
                rgba(99, 102, 241, 0.3));
            border: 1px solid rgba(139, 92, 246, 0.5);
            border-radius: 20px;
            font-size: 0.6875rem;
            font-weight: 800;
            text-transform: uppercase;
            letter-spacing: 1.2px;
            color: var(--accent);
            box-shadow: 
                0 4px 16px rgba(139, 92, 246, 0.3),
                0 0 0 1px rgba(139, 92, 246, 0.2) inset;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .beta-badge::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(255, 255, 255, 0.2), 
                transparent);
            transition: left 0.5s ease;
        }

        .beta-badge:hover {
            transform: translateY(-2px) scale(1.05);
            box-shadow: 
                0 8px 24px rgba(139, 92, 246, 0.4),
                0 0 0 1px rgba(139, 92, 246, 0.3) inset;
            border-color: rgba(139, 92, 246, 0.7);
        }

        .beta-badge:hover::before {
            left: 100%;
        }

        .header-center {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: var(--spacing-md);
            position: relative;
            z-index: 1;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: var(--spacing-md);
            position: relative;
            z-index: 1;
        }

        .header-stats {
            display: flex;
            align-items: center;
            gap: var(--spacing-lg);
            padding: var(--spacing-sm) var(--spacing-lg);
            background: rgba(148, 163, 184, 0.05);
            border: 1px solid var(--border-secondary);
            border-radius: 16px;
            backdrop-filter: blur(10px);
        }

        .status-badge-container {
            display: flex;
            flex-direction: column;
            gap: 6px;
            align-items: center;
        }

        .header-badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 12px 24px;
            background: linear-gradient(135deg, 
                rgba(148, 163, 184, 0.15), 
                rgba(100, 116, 139, 0.15));
            border: 1px solid rgba(148, 163, 184, 0.3);
            border-radius: 28px;
            font-size: 0.8125rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1.2px;
            color: var(--text-secondary);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 
                0 4px 16px rgba(0, 0, 0, 0.2),
                0 0 0 1px rgba(255, 255, 255, 0.05) inset;
            position: relative;
            overflow: hidden;
        }

        .header-badge::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, 
                rgba(255, 255, 255, 0.1), 
                transparent);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .header-badge.live {
            background: linear-gradient(135deg, 
                rgba(16, 185, 129, 0.25), 
                rgba(6, 182, 212, 0.25));
            border-color: rgba(16, 185, 129, 0.5);
            color: var(--success);
            box-shadow: 
                0 6px 24px rgba(16, 185, 129, 0.4),
                0 0 0 1px rgba(16, 185, 129, 0.2) inset,
                0 0 40px rgba(16, 185, 129, 0.3);
            animation: pulse-glow 2.5s ease-in-out infinite;
        }

        @keyframes pulse-glow {
            0%, 100% {
                box-shadow: 
                    0 6px 24px rgba(16, 185, 129, 0.4),
                    0 0 0 1px rgba(16, 185, 129, 0.2) inset,
                    0 0 40px rgba(16, 185, 129, 0.3);
            }
            50% {
                box-shadow: 
                    0 8px 32px rgba(16, 185, 129, 0.6),
                    0 0 0 1px rgba(16, 185, 129, 0.3) inset,
                    0 0 60px rgba(16, 185, 129, 0.5);
            }
        }

        .header-badge.offline {
            background: linear-gradient(135deg, 
                rgba(148, 163, 184, 0.15), 
                rgba(100, 116, 139, 0.15));
            border-color: rgba(148, 163, 184, 0.3);
            color: var(--text-tertiary);
        }

        .header-badge:hover {
            transform: translateY(-3px) scale(1.02);
        }

        .header-badge:hover::before {
            opacity: 1;
        }

        .header-badge.live:hover {
            box-shadow: 
                0 10px 40px rgba(16, 185, 129, 0.5),
                0 0 0 1px rgba(16, 185, 129, 0.3) inset,
                0 0 80px rgba(16, 185, 129, 0.4);
        }

        .header-badge-icon {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: currentColor;
            display: inline-block;
            box-shadow: 0 0 12px currentColor;
            position: relative;
        }

        .header-badge.live .header-badge-icon {
            animation: pulse-dot 2s ease-in-out infinite;
        }

        .header-badge.live .header-badge-icon::after {
            content: '';
            position: absolute;
            inset: -4px;
            border-radius: 50%;
            border: 2px solid currentColor;
            opacity: 0.5;
            animation: ripple 2s ease-out infinite;
        }

        @keyframes pulse-dot {
            0%, 100% { 
                opacity: 1; 
                transform: scale(1);
            }
            50% { 
                opacity: 0.8; 
                transform: scale(1.3);
            }
        }

        @keyframes ripple {
            0% {
                transform: scale(0.8);
                opacity: 0.5;
            }
            100% {
                transform: scale(2);
                opacity: 0;
            }
        }

        .nav-link {
            color: var(--text-secondary);
            text-decoration: none;
            font-size: 0.875rem;
            font-weight: 600;
            padding: 10px 18px;
            border-radius: var(--radius-md);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            gap: 8px;
            background: rgba(148, 163, 184, 0.05);
            border: 1px solid var(--border-secondary);
        }

        .nav-link:hover {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.1), rgba(6, 182, 212, 0.1));
            color: var(--text-primary);
            border-color: var(--border-primary);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(99, 102, 241, 0.2);
        }

        .timestamp {
            font-size: 0.8125rem;
            color: var(--text-tertiary);
            font-family: 'JetBrains Mono', monospace;
            padding: 10px 16px;
            background: var(--bg-tertiary);
            border: 1px solid var(--border-secondary);
            border-radius: var(--radius-md);
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .timestamp:hover {
            background: var(--bg-secondary);
            color: var(--text-secondary);
            border-color: var(--border-primary);
        }

        .timestamp i {
            opacity: 0.6;
            font-size: 0.75rem;
        }

        .tabs-container {
            background: var(--bg-elevated);
            border: 1px solid var(--border-secondary);
            border-radius: var(--radius-xl);
            padding: var(--spacing-md);
            display: flex;
            gap: var(--spacing-sm);
            overflow-x: auto;
            box-shadow: var(--shadow-sm);
            position: sticky;
            top: var(--spacing-xl);
            z-index: 50;
            margin-bottom: var(--spacing-lg);
        }

        .tab-button {
            flex: 1;
            min-width: 140px;
            padding: var(--spacing-md) var(--spacing-lg);
            background: transparent;
            border: none;
            border-radius: var(--radius-lg);
            color: var(--text-tertiary);
            font-size: 0.875rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: var(--spacing-xs);
            position: relative;
            overflow: hidden;
        }

        .tab-button::before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            border-radius: 3px 3px 0 0;
            transition: width 0.3s ease;
        }

        .tab-button:hover {
            background: rgba(148, 163, 184, 0.05);
            color: var(--text-secondary);
        }

        .tab-button.active {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.15), rgba(6, 182, 212, 0.15));
            color: var(--text-primary);
            box-shadow: 0 2px 8px rgba(99, 102, 241, 0.2);
        }

        .tab-button.active::before {
            width: 80%;
        }

        .tab-icon {
            font-size: 1rem;
        }

        .tab-content {
            display: none;
            animation: fadeIn 0.4s ease-in-out;
        }

        .tab-content.active {
            display: block;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .content-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: var(--spacing-lg);
        }

        .content-grid.full-width {
            grid-template-columns: 1fr;
        }

        .content-grid.two-col {
            grid-template-columns: repeat(2, 1fr);
        }

        .content-grid.three-col {
            grid-template-columns: repeat(3, 1fr);
        }

        .card {
            background: var(--bg-elevated);
            border: 1px solid var(--border-secondary);
            border-radius: var(--radius-xl);
            padding: var(--spacing-xl);
            box-shadow: var(--shadow-sm);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, var(--primary), var(--secondary));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .card:hover {
            box-shadow: var(--shadow-md);
            border-color: var(--border-primary);
            transform: translateY(-2px);
        }

        .card:hover::before {
            opacity: 1;
        }

        .card.vod-metrics {
            border-left: 3px solid var(--vod-color);
        }

        .card.live-metrics {
            border-left: 3px solid var(--live-color);
        }

        .profile-card {
            text-align: center;
            padding: var(--spacing-2xl) var(--spacing-xl);
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.05), rgba(6, 182, 212, 0.05));
            position: sticky;
            top: calc(var(--spacing-xl) + 80px);
        }

        .avatar-container {
            position: relative;
            display: inline-block;
            margin-bottom: var(--spacing-lg);
        }

        .avatar {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 3px solid var(--border-primary);
            object-fit: cover;
            box-shadow: 0 4px 20px rgba(99, 102, 241, 0.2);
            transition: transform 0.3s ease;
        }

        .avatar-container:hover .avatar {
            transform: scale(1.05);
        }

        .status-indicator {
            position: absolute;
            bottom: 8px;
            right: 8px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            border: 3px solid var(--bg-elevated);
            background: var(--text-muted);
        }

        .status-indicator.live {
            background: var(--success);
            box-shadow: 0 0 0 4px rgba(16, 185, 129, 0.2);
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        .streamer-name {
            font-size: 1.625rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: var(--spacing-xs);
            letter-spacing: -0.75px;
            line-height: 1.3;
        }

        .streamer-handle {
            font-size: 0.9375rem;
            color: var(--text-tertiary);
            margin-bottom: var(--spacing-lg);
            font-family: 'JetBrains Mono', monospace;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: var(--spacing-xs);
            padding: var(--spacing-xs) var(--spacing-md);
            border-radius: var(--radius-lg);
            font-size: 0.8125rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge.live {
            background: rgba(16, 185, 129, 0.15);
            color: var(--success);
            border: 1px solid rgba(16, 185, 129, 0.3);
        }

        .status-badge.offline {
            background: rgba(148, 163, 184, 0.1);
            color: var(--text-tertiary);
            border: 1px solid var(--border-secondary);
        }

        .stats-list {
            list-style: none;
        }

        .stat-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: var(--spacing-md);
            border-bottom: 1px solid var(--border-secondary);
        }

        .stat-item:last-child {
            border-bottom: none;
        }

        .stat-label {
            font-size: 0.875rem;
            color: var(--text-tertiary);
            font-weight: 500;
        }

        .stat-value {
            font-size: 1.0625rem;
            font-weight: 600;
            color: var(--text-primary);
            font-family: 'JetBrains Mono', monospace;
            letter-spacing: -0.3px;
        }

        .section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: var(--spacing-xl);
        }

        .section-title {
            font-size: 1.375rem;
            font-weight: 700;
            color: var(--text-primary);
            letter-spacing: -0.75px;
            display: flex;
            align-items: center;
            gap: var(--spacing-sm);
        }

        .section-title::before {
            content: '';
            width: 4px;
            height: 20px;
            background: linear-gradient(180deg, var(--primary), var(--secondary));
            border-radius: 2px;
        }

        .section-badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .section-badge.vod {
            background: rgba(139, 92, 246, 0.15);
            color: var(--vod-color);
            border: 1px solid rgba(139, 92, 246, 0.3);
        }

        .section-badge.live {
            background: rgba(16, 185, 129, 0.15);
            color: var(--live-color);
            border: 1px solid rgba(16, 185, 129, 0.3);
        }

        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: var(--spacing-md);
        }

        .metric-card {
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.03), rgba(139, 92, 246, 0.03));
            border: 1px solid var(--border-secondary);
            border-radius: var(--radius-lg);
            padding: var(--spacing-lg);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .metric-card::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.05), rgba(6, 182, 212, 0.05));
            opacity: 0;
            transition: opacity 0.3s ease;
            pointer-events: none;
        }

        .metric-card:hover {
            border-color: var(--border-primary);
            transform: translateY(-3px);
            box-shadow: var(--shadow-md);
        }

        .metric-card:hover::after {
            opacity: 1;
        }

        .metric-card.vod {
            border-left: 3px solid var(--vod-color);
        }

        .metric-card.live {
            border-left: 3px solid var(--live-color);
        }

        .metric-icon {
            width: 40px;
            height: 40px;
            border-radius: var(--radius-md);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.125rem;
            margin-bottom: var(--spacing-sm);
        }

        .metric-icon.vod {
            background: rgba(139, 92, 246, 0.15);
            color: var(--vod-color);
        }

        .metric-icon.live {
            background: rgba(16, 185, 129, 0.15);
            color: var(--live-color);
        }

        .metric-value {
            font-size: 2.25rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: var(--spacing-xs);
            font-family: 'JetBrains Mono', monospace;
            letter-spacing: -1.5px;
            line-height: 1.2;
        }

        .metric-label {
            font-size: 0.8125rem;
            color: var(--text-tertiary);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            margin-top: var(--spacing-xs);
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .metric-label-icon {
            font-size: 0.75rem;
            opacity: 0.6;
        }

        .chart-container {
            position: relative;
            height: 320px;
            margin-top: var(--spacing-lg);
            padding: var(--spacing-md);
            background: var(--bg-secondary);
            border-radius: var(--radius-md);
            border: 1px solid var(--border-secondary);
        }

        .vod-list {
            list-style: none;
            display: flex;
            flex-direction: column;
            gap: var(--spacing-sm);
        }

        .vod-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: var(--spacing-md) var(--spacing-lg);
            background: var(--bg-secondary);
            border: 1px solid var(--border-secondary);
            border-left: 3px solid var(--vod-color);
            border-radius: var(--radius-md);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .vod-item:hover {
            background: var(--bg-tertiary);
            border-color: var(--border-primary);
            transform: translateX(4px);
            box-shadow: var(--shadow-sm);
        }

        .vod-title {
            font-size: 0.9375rem;
            font-weight: 500;
            color: var(--text-primary);
            flex: 1;
            line-height: 1.5;
            margin-right: var(--spacing-md);
        }

        .vod-meta {
            display: flex;
            align-items: center;
            gap: var(--spacing-lg);
            font-size: 0.8125rem;
            color: var(--text-tertiary);
            font-family: 'JetBrains Mono', monospace;
        }

        .vod-meta-item {
            display: flex;
            align-items: center;
            gap: var(--spacing-xs);
        }

        .growth-indicator {
            display: inline-flex;
            align-items: center;
            gap: var(--spacing-xs);
            font-size: 0.8125rem;
            font-weight: 600;
            padding: 2px 8px;
            border-radius: var(--radius-sm);
        }

        .growth-indicator.positive {
            background: rgba(16, 185, 129, 0.15);
            color: var(--success);
        }

        .growth-indicator.negative {
            background: rgba(239, 68, 68, 0.15);
            color: var(--danger);
        }

        .footer {
            grid-column: 1 / -1;
            text-align: center;
            padding: var(--spacing-xl) 0;
            border-top: 1px solid var(--border-secondary);
            margin-top: var(--spacing-xl);
        }

        .footer-content {
            color: var(--text-tertiary);
            font-size: 0.875rem;
        }

        .boot-anim {
            animation: fadeInUp 0.6s cubic-bezier(0.4, 0, 0.2, 1) forwards;
            opacity: 0;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(24px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @media (max-width: 1200px) {
            .container {
                grid-template-columns: 300px 1fr;
                padding: var(--spacing-lg);
            }
        }

        @media (max-width: 968px) {
            .dashboard-wrapper {
                grid-template-columns: 1fr;
            }

            .profile-sidebar {
                order: 2;
            }

            .main-content {
                order: 1;
            }

            .tabs-container {
                position: relative;
                top: 0;
            }

            .tabs-container {
                flex-wrap: wrap;
                gap: var(--spacing-xs);
            }

            .tab-button {
                min-width: auto;
                flex: 1 1 auto;
                padding: var(--spacing-sm) var(--spacing-md);
                font-size: 0.8125rem;
            }

            .content-grid {
                grid-template-columns: 1fr;
            }

            .header-top {
                grid-template-columns: 1fr;
                gap: var(--spacing-lg);
                padding: var(--spacing-lg);
            }

            .logo-section {
                justify-content: center;
            }

            .header-center {
                justify-content: center;
            }

            .header-actions {
                justify-content: center;
                flex-wrap: wrap;
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: var(--spacing-md) var(--spacing-lg);
            }

            .logo {
                font-size: 1.375rem;
            }

            .logo-icon {
                width: 36px;
                height: 36px;
                font-size: 1.125rem;
            }

            .header-badge {
                font-size: 0.6875rem;
                padding: 6px 12px;
            }

            .timestamp {
                font-size: 0.75rem;
                padding: 6px 10px;
            }

            .nav-link {
                font-size: 0.8125rem;
                padding: 6px 12px;
            }
        }

        @media (max-width: 640px) {
            .container {
                padding: var(--spacing-md);
                gap: var(--spacing-md);
            }

            .metrics-grid {
                grid-template-columns: 1fr;
            }

            .header-top {
                padding: var(--spacing-md) var(--spacing-lg);
                gap: var(--spacing-md);
            }

            .logo-section {
                flex-direction: column;
                align-items: center;
                text-align: center;
                gap: var(--spacing-sm);
            }

            .logo {
                flex-direction: column;
                gap: var(--spacing-sm);
            }

            .logo-text-wrapper {
                align-items: center;
            }

            .logo-text {
                font-size: 1.5rem;
            }

            .logo-icon-wrapper {
                width: 56px;
                height: 56px;
            }

            .logo-icon {
                width: 56px;
                height: 56px;
                font-size: 1.5rem;
            }

            .beta-badge {
                font-size: 0.625rem;
                padding: 4px 12px;
            }

            .header-center {
                width: 100%;
            }

            .header-stats {
                width: 100%;
                justify-content: center;
            }

            .header-actions {
                width: 100%;
                flex-direction: column;
                gap: var(--spacing-sm);
            }

            .nav-link {
                width: 100%;
                justify-content: center;
            }

            .timestamp {
                font-size: 0.75rem;
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="container">
