    <footer class="footer">
        <div class="footer-content">
            <p>&copy; <?php echo date('Y'); ?> Vertali Group. All Rights Reserved.</p>
        </div>
    </footer>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Tab switching functionality
            const tabButtons = document.querySelectorAll('.tab-button');
            const tabContents = document.querySelectorAll('.tab-content');

            tabButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const targetTab = button.getAttribute('data-tab');

                    // Remove active class from all buttons and contents
                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    tabContents.forEach(content => content.classList.remove('active'));

                    // Add active class to clicked button and corresponding content
                    button.classList.add('active');
                    const targetContent = document.getElementById(targetTab + '-tab');
                    if (targetContent) {
                        targetContent.classList.add('active');
                    }
                });
            });

            // Update timestamp
            const timeElement = document.getElementById('last-updated-time');
            if(timeElement) {
                const timeSpan = timeElement.querySelector('span');
                if (timeSpan) {
                    setInterval(() => {
                        const now = new Date();
                        timeSpan.textContent = now.toLocaleString('en-US', {
                            year: 'numeric', month: 'short', day: 'numeric',
                            hour: '2-digit', minute: '2-digit', second: '2-digit',
                            hour12: true,
                            timeZone: 'America/New_York',
                            timeZoneName: 'short'
                        }).replace(',', ' ·');
                    }, 1000);
                }
            }

            // Initialize charts
            if (typeof Chart !== 'undefined') {
                Chart.defaults.color = '#CBD5E1';
                Chart.defaults.borderColor = 'rgba(148, 163, 184, 0.1)';
                Chart.defaults.font.family = "'Inter', sans-serif";
                Chart.defaults.font.size = 12;

                const chartOptions = {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            labels: {
                                color: '#CBD5E1',
                                font: { size: 12, weight: '500' },
                                padding: 15,
                                usePointStyle: true
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(15, 23, 42, 0.95)',
                            titleColor: '#F1F5F9',
                            bodyColor: '#CBD5E1',
                            borderColor: 'rgba(99, 102, 241, 0.3)',
                            borderWidth: 1,
                            padding: 12,
                            cornerRadius: 8,
                            displayColors: true
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                color: '#94A3B8',
                                font: { size: 11 }
                            },
                            grid: {
                                color: 'rgba(148, 163, 184, 0.05)',
                                drawBorder: false
                            }
                        },
                        x: {
                            ticks: {
                                color: '#94A3B8',
                                font: { size: 11 }
                            },
                            grid: {
                                display: false
                            }
                        }
                    }
                };

                <?php if (isset($dailyStats) && count($dailyStats) > 0): ?>
                const dailyCtx = document.getElementById('dailyTrendChart');
                if (dailyCtx) {
                    const dailyData = <?php echo json_encode($dailyStats); ?>;
                    const labels = dailyData.map(d => {
                        const date = new Date(d.date);
                        return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric' });
                    });
                    const viewsData = dailyData.map(d => d.total_views);
                    const streamsData = dailyData.map(d => d.streams);
                    
                    new Chart(dailyCtx, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Daily Views',
                                data: viewsData,
                                borderColor: '#6366F1',
                                backgroundColor: 'rgba(99, 102, 241, 0.1)',
                                borderWidth: 2,
                                fill: true,
                                tension: 0.4,
                                pointRadius: 3,
                                pointHoverRadius: 5
                            }, {
                                label: 'Streams',
                                data: streamsData,
                                borderColor: '#06B6D4',
                                backgroundColor: 'rgba(6, 182, 212, 0.1)',
                                borderWidth: 2,
                                fill: true,
                                tension: 0.4,
                                pointRadius: 3,
                                pointHoverRadius: 5,
                                yAxisID: 'y1'
                            }]
                        },
                        options: {
                            ...chartOptions,
                            scales: {
                                ...chartOptions.scales,
                                y1: {
                                    type: 'linear',
                                    display: true,
                                    position: 'right',
                                    beginAtZero: true,
                                    ticks: {
                                        color: '#94A3B8',
                                        font: { size: 11 }
                                    },
                                    grid: {
                                        drawOnChartArea: false
                                    }
                                }
                            }
                        }
                    });
                }
                <?php endif; ?>

                <?php if (!empty($popularGames)): ?>
                const gamesCtx = document.getElementById('gamesChart');
                if (gamesCtx) {
                    const gameNames = <?php echo json_encode(array_keys($popularGames)); ?>;
                    const gameCounts = <?php echo json_encode(array_values($popularGames)); ?>;
                    
                    new Chart(gamesCtx, {
                        type: 'doughnut',
                        data: {
                            labels: gameNames,
                            datasets: [{
                                data: gameCounts,
                                backgroundColor: [
                                    '#6366F1',
                                    '#06B6D4',
                                    '#8B5CF6',
                                    '#10B981',
                                    '#F59E0B'
                                ],
                                borderWidth: 0
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: {
                                    position: 'right',
                                    labels: {
                                        color: '#CBD5E1',
                                        padding: 12,
                                        font: { size: 12 }
                                    }
                                },
                                tooltip: {
                                    backgroundColor: 'rgba(15, 23, 42, 0.95)',
                                    titleColor: '#F1F5F9',
                                    bodyColor: '#CBD5E1',
                                    borderColor: 'rgba(99, 102, 241, 0.3)',
                                    borderWidth: 1,
                                    padding: 12,
                                    cornerRadius: 8
                                }
                            }
                        }
                    });
                }
                <?php endif; ?>

                <?php if (isset($hourlyPatterns) && array_sum(array_column($hourlyPatterns, 'count')) > 0): ?>
                const hourlyCtx = document.getElementById('hourlyChart');
                if (hourlyCtx) {
                    const hours = Array.from({length: 24}, (_, i) => i + ':00');
                    const hourlyCounts = <?php echo json_encode(array_column($hourlyPatterns, 'count')); ?>;
                    
                    new Chart(hourlyCtx, {
                        type: 'bar',
                        data: {
                            labels: hours,
                            datasets: [{
                                label: 'Streams Started',
                                data: hourlyCounts,
                                backgroundColor: 'rgba(99, 102, 241, 0.6)',
                                borderColor: '#6366F1',
                                borderWidth: 1,
                                borderRadius: 4
                            }]
                        },
                        options: chartOptions
                    });
                }
                <?php endif; ?>

                <?php if (isset($streamSchedule) && !empty($streamSchedule)): ?>
                const scheduleCtx = document.getElementById('scheduleChart');
                if (scheduleCtx) {
                    const days = <?php echo json_encode(array_keys($streamSchedule)); ?>;
                    const dayCounts = <?php echo json_encode(array_values($streamSchedule)); ?>;
                    
                    new Chart(scheduleCtx, {
                        type: 'bar',
                        data: {
                            labels: days,
                            datasets: [{
                                label: 'Streams',
                                data: dayCounts,
                                backgroundColor: 'rgba(6, 182, 212, 0.6)',
                                borderColor: '#06B6D4',
                                borderWidth: 1,
                                borderRadius: 4
                            }]
                        },
                        options: chartOptions
                    });
                }
                <?php endif; ?>

                <?php if (isset($streamInfo) && $streamInfo): ?>
                // Auto-refresh live stream metrics
                let refreshInterval = 30000; // 30 seconds
                
                function updateLiveMetrics() {
                    const username = '<?php echo urlencode($broadcasterLogin); ?>';
                    fetch('?username=' + username + '&ajax=1&t=' + Date.now())
                        .then(response => response.text())
                        .then(html => {
                            // Parse the response to extract metrics
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(html, 'text/html');
                            
                            // Update current viewers
                            const currentViewersEl = doc.querySelector('#current-viewers .metric-value');
                            if (currentViewersEl) {
                                const currentEl = document.querySelector('#current-viewers .metric-value');
                                if (currentEl) {
                                    currentEl.textContent = currentViewersEl.textContent;
                                }
                            }
                            
                            // Update average viewers
                            const avgViewersEl = doc.querySelector('#avg-viewers .metric-value');
                            if (avgViewersEl) {
                                const avgEl = document.querySelector('#avg-viewers .metric-value');
                                if (avgEl) {
                                    avgEl.textContent = avgViewersEl.textContent;
                                }
                            }
                            
                            // Update peak viewers
                            const peakViewersEl = doc.querySelector('#peak-viewers .metric-value');
                            if (peakViewersEl) {
                                const peakEl = document.querySelector('#peak-viewers .metric-value');
                                if (peakEl) {
                                    peakEl.textContent = peakViewersEl.textContent;
                                }
                            }
                        })
                        .catch(error => {
                            console.error('Error updating live metrics:', error);
                        });
                }
                
                // Update metrics every 30 seconds
                setInterval(updateLiveMetrics, refreshInterval);
                <?php endif; ?>
            }
        });
    </script>
</body>
</html>
